;Copyright 1999 by Henter-Joyce, Inc.  
;scripts for MAGic Magnification Software 5.0 and 6.0
;written by j.c

Include "hjconst.jsh"
Include "hjglobal.jsh"
Include "Winmagic.jsh"
Include "Winmagic.jsm"


Int Function GetMagicVersion ()
var 
  int SetMagicVersion
  Let SetMagicVersion = GetProgramVersion (GetAppFilePath ()) 
If (SetMagicVersion == 6) then
  Return 6
Else
  Return 5
endIf
  Return 0
EndFunction

String Function GetCurrentPage ()
var
  handle WindowHandle
  let WindowHandle = GetFocus ()
  SaveCursor ()
  InvisibleCursor ()
If (FindString (WindowHandle, msg1, s_bottom, s_unrestricted)) then
  Return msg2
Elif (FindString (WindowHandle, msg3, s_bottom, s_unrestricted)) then
  Return msg4
Elif (FindString (WindowHandle, msg5, s_bottom, s_unrestricted)) then
  Return msg6
Elif (FindString (WindowHandle, msg7, s_bottom, s_unrestricted)) then
  Return msg8
EndIf   
  Return msg9
EndFunction

Function AutoStartEvent ()
var
  int IVerbosity
  let IVerbosity = GetVerbosity ()
  let MagicVersion = GetMagicVersion ()
  let CurrentPage = GetCurrentPage ()
If (MagicMagnificationFirstTime == 0) then
  let magicMagnificationFirstTime = 1
If (IVerbosity == beginner) then
  Say (msg10, ot_help)
  Say (msg11, ot_help)
  Say (msg12, ot_help)
EndIf
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames (msg13)
EndScript

Script SayNextCharacter ()
var
  handle WindowHandle,
  int IControlID
  let WindowHandle = GetFocus ()
  let IControlID = GetControlID (WindowHandle)
  PerformScript SayNextCharacter ()
If (MagicVersion <= 5) then
If (IControlID == TabControl) then 
  let CurrentPage = GetChunk () + msg14
  Say (CurrentPage, ot_control_name)
EndIf
EndIf
  let CurrentPage = GetCurrentPage ()
EndScript

Script SayPriorCharacter ()
var
  handle WindowHandle,
  int IControlID
  let WindowHandle = GetFocus ()
  let IControlID = GetControlID (WindowHandle)
  PerformScript SayPriorCharacter ()
If (MagicVersion <= 5) then
If (IControlID == TabControl) then 
  let CurrentPage = GetChunk () + msg14
  Say (CurrentPage, ot_control_name)
EndIf
EndIf
  let CurrentPage = GetCurrentPage ()
EndScript

Int Function SayPrompt (int nID)
If (nID == AREA_FULL_SCREEN) then
  Say (msg15, ot_message)
  Return false
EndIf
If (nID == PREDICTIVE_FRAME_HORIZONTAL) then 
	Say(msg16, ot_message)
  Return True 
ElIf (nID == PREDICTIVE_FRAME_VERTICAL) then 
	Say(msg17, ot_message)	
  Return True 
ElIf (nID == PREDICTIVE_ADJUST_HORIZONTAL) then 
	Say(msg18, ot_message) 
	Return True 
ElIf (nID == PREDICTIVE_ADJUST_VERTICAL) then 
	Say(msg19, ot_message) 
	Return True 
EndIf
If (nID == SPEED_HORIZONTAL) then 
	Say(msg20, ot_message) 
	Return True 
ElIf (nID == SPEED_VERTICAL) then 
	Say(msg21, ot_message) 
	Return TRUE 
EndIf
If (nID == JUMP_HORIZONTAL) then 
	Say(msg22, ot_message) 
	Return TRUE 
ElIf (nID == JUMP_VERTICAL) then 
	Say(msg23, ot_message) 
	Return TRUE 
ElIf (nID == DELAY_START) then 
	Say(msg24, ot_message) 
	Return TRUE 
ElIf (nID == DELAY_STOP) then 
	Say(msg25, ot_message) 
	Return TRUE 
ElIf (nID == ISSUE_PAGE_DOWN_DELAY) then 
	Say(msg26, ot_message) 
	Return TRUE 
ElIf (nID == AREA_DESKTOP) then 
	Say(msg27, ot_message) 
	Return FALSE 
ElIf (nID == AREA_WINDOW) then 
	Say(msg28, ot_message) 
	Return FALSE 
ElIf (nID == PAN_RIGHT) then 
	Say(msg29, ot_message) 
	Return FALSE 
elIf (nID == PAN_LEFT) then 
	Say(msg30, ot_message) 
	Return FALSE
ElIf (nID == PAN_DOWN) then 
	Say(msg31, ot_message) 
	Return FALSE
elIf (nID == PAN_UP) then 
	Say(msg32, ot_message) 
	Return FALSE
ElIf (nID == FEATURE_COMBO) then 
	Say(msg33, ot_message) 
	Return TRUE 
EndIf
If (nID == TRACKING_IGNORE_RIGHT) then
	Say(msg34, ot_message) 
	Return TRUE
ElIf (nID == TRACKING_IGNORE_LOWER) then
	Say(msg35, ot_message) 
	Return TRUE
ElIf (nID == TRACKING_MINIMUM_BITMAP) then
	Say(msg36, ot_message) 
	Return TRUE
ElIf (nID == TRACKING_HORIZONTAL_TEXT) then
	Say(msg37, ot_message) 
	Return TRUE
ElIf (nID == TRACKING_VERTICAL_TEXT_ADJUSTMENT) then
	Say(msg38, ot_message) 
	Return TRUE
EndIf
  Return 3
EndFunction

Function SayMagicwindowPromptAndText (int nMethod)
var
  handle WindowHandle
  let WindowHandle = GetFocus ()
If (nMethod == TRUE) then
	SayWindow (WindowHandle, READ_EVERYTHING)
	Return
EndIf
If (nMethod == FALSE) then
	Return
EndIf
If (nMethod == 3) then
  SayWindowTypeAndText (WindowHandle)
  Return
EndIf
EndFunction

Script SayWindowTitle ()
var
  int nResult,
  string WindowName,
  int IControlID
  let IControlId = GetControlID (GetFocus ())
  let WindowName = GetWindowName ( GetAppMainWindow (GetFocus ()))
If (MagicVersion <= 5) then
	  Say (WindowName, ot_window_name)
  Say (CurrentPage, ot_control_name)
  If (GlobalMenuMode ==MENU_INACTIVE && IControlID != TabControl) then
  SayMagicWindowPromptAndText (IControlID)
  Return
EndIf 
  Return
EndIf
	  PerformScript SayWindowTitle()
EndScript

Function SayFocusedWindow ()
var
  int IControlID
  let IControlId = GetControlID (getFocus ())
If (MagicVersion <= 5) then
  SayMagicWindowPromptAndText (IControlID)
  Return
EndIf
  SayFocusedWindow () 
EndFunction

Script NextDocumentWindow ()
If (MagicVersion <= 5) then
If (CurrentPage == msg2) then
  {Alt + T}
ElIf (currentPage == msg4) then
  {Alt + N}
Elif (currentPage == msg6) then
  {Alt + K}
elIf (CurrentPage == msg8) then
  {Alt + A}
ElIf (CurrentPage == msg9) then
  {Alt + M}
EndIf
  let CurrentPage = getChunk () + msg14
  Say (CurrentPage, ot_control_name)
  let CurrentPage = GetCurrentPage ()
  Return
EndIf
  let CurrentPage = GetCurrentPage ()
  PerformScript NextDocumentWindow ()
EndScript

Script PreviousDocumentWindow ()
var
  int IControlID
  let IControlID = GetControlID (getFocus ())
If (MagicVersion <= 5) then
If (CurrentPage == msg2) then
If (IControlID != MAGNIFICATION_EDIT) then
  {Alt+ A}
Else
  Say (CurrentPage, ot_control_name)
  Return
endIf  
endIf
If (CurrentPage == msg4) then
  {Alt + M}
ElIf (CurrentPage == msg6) then
  {Alt+ T}
ElIf (CurrentPage == msg8) then
  {Alt + N}
ElIf (CurrentPage == msg9) then
  {Alt + K}
EndIf
  let CurrentPage = GetChunk () + msg14
  Say (CurrentPage, ot_control_name)
  let CurrentPage = GetCurrentPage ()
  Return
EndIf	
  let CurrentPage = GetCurrentPage ()
  PerformScript PreviousDocumentWindow ()
EndScript

Script ScreenSensitiveHelp ()
If (IsSameScript ()) then
  AppFileTopic ()
  Return
endIf
  Say (msg39, ot_help)
  Pause ()
  {Shift + F1}
EndScript
